#!/bin/bash
ROOT="/var/dist"
DIRT="/var/dist/conf"
DEBS="/root/repos/*.deb"

mkdir -p $DIRT
cd $DIRT

#Создаем gpg ключ
gpg --gen-key

#Создаем шаблон репозитория
DIST="distributions"
touch $DIST
echo "Origin: Debian" >> $DIST
echo "Label: Debian" >> $DIST
echo "Suite: stable" >> $DIST
echo "Version: 12.5" >> $DIST
echo "Codename: bookworm" >> $DIST
echo "Achitectures: amd64" >> $DIST
echo "Components: main contrib non-free-firmware non-free" >> $DIST
SIGN="SignWith: "

#Парсим public keyID
FPRNT=$(gpg --list-keys --with-subkey-fingerprint | grep -Po '\w{40}' | sed '2!d')
echo $SIGN$FPRNT >> $DIST

#Настройка reprepro
cd $ROOT
reprepro export
reprepro createsymlinks
cd $DIRT

echo "verbose" >> option
echo $ROOT >> option
echo "ask-passphrase" >> option

#Добавляем *.deb пакеты в репозиторий
reprepro -b $ROOT includedeb bookworm $DEBS

#Создаем публичный ключ
gpg --armor --output whatever.gpg --export-options export-minimal --export $FPRNT
cd
chown -R _apt:root $ROOT
chmod -R 700 $ROOT

#Локальный sources.list
#deb file:$ROOT bookworm main contrib non-free
#cp $DIRT/whatever.gpg /etc/apt/trusted.gpg.d/whatever.asc