# Portainer и способы подключения внешних Docker-хостов

Portainer позволяет добавлять в свою панель не только локальный Docker-демон, но и удалённые Docker-хосты. Способы интеграции бывают разные — часть из них предназначена для Docker Swarm, Kubernetes или Podman, но мы рассмотрим лишь два метода, актуальных для классического Docker и Docker Compose:

- Прямое подключение к Docker API по TCP.
- Использование Portainer Agent.

Разберём каждый метод подробнее.

---

## 1. Подключение по Docker API

При таком подходе Portainer напрямую обращается к Docker-демону на удалённом сервере через HTTP(S). Docker-демон должен слушать TCP-порт `2375` (без TLS) или `2376` (с TLS), а Portainer при добавлении эндпоинта указывает соответствующий адрес.

### Настройка на хосте

Откройте файл конфигурации Docker-демона:

```bash
sudo nano /etc/docker/daemon.json
```

Добавьте блок `hosts`:

#### Без TLS (все запросы открыты):

```json
{
  "hosts": [
    "unix:///var/run/docker.sock",
    "tcp://0.0.0.0:2375"
  ]
}
```

#### С TLS (шифрование трафика):

```json
{
  "tlsverify": true,
  "tlscacert": "/path/to/ca.pem",
  "tlscert": "/path/to/server-cert.pem",
  "tlskey": "/path/to/server-key.pem",
  "hosts": [
    "unix:///var/run/docker.sock",
    "tcp://0.0.0.0:2376"
  ]
}
```

Перезапустите Docker:

```bash
sudo systemctl restart docker
```

> 🔒 **Важно**: если вы отключаете TLS-шифрование, обязательно настройте firewall так, чтобы доступ к порту был только с доверенных IP-адресов. Иначе любой сможет управлять вашим Docker.

### Плюсы и минусы

| Плюсы | Минусы |
|-------|--------|
| • Не требуется дополнительное ПО на хосте — только сам Docker-демон.<br>• Прямой «родной» API-доступ без прокси. | • Настройка TLS и ротация сертификатов добавляют сложность.<br>• Без надёжного шифрования и firewall — уязвимость для посторонних. |
